<?php
session_start();
include 'conexao.php'; // Garante a conexão com o banco de dados

// Verifica se o formulário foi submetido via POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Obtém os dados do formulário
    $aluno_id = $_POST['aluno_id'];
    $mes_pagamento = $_POST['mes_pagamento'];
    $valor_pago = $_POST['valor'];
    $data_pagamento = date('Y-m-d H:i:s');
    $status = 'Pago'; // Definindo o status como 'Pago' por padrão

    // Validação básica para garantir que os campos não estão vazios
    if (empty($aluno_id) || empty($mes_pagamento) || empty($valor_pago)) {
        die("Erro: Todos os campos são obrigatórios.");
    }
    
    // Prepara a consulta SQL para inserção de dados
    $sql = "INSERT INTO propinas (aluno_id, mes_pagamento, valor_pago, data_pagamento, status) VALUES (?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    
    // Associa os parâmetros à consulta preparada
    // 'issis' significa: i=integer (aluno_id), s=string (mes_pagamento), s=string (valor_pago), i=integer (data_pagamento)
    $stmt->bind_param("issss", $aluno_id, $mes_pagamento, $valor_pago, $data_pagamento, $status);
    
    // Executa a consulta
    if ($stmt->execute()) {
        echo "Pagamento de propina registrado com sucesso! ✔️";
        // Opcional: Redireciona para uma página de sucesso ou painel após 3 segundos
        header("refresh:3;url=painel_secretaria_geral.php");
    } else {
        echo "Erro ao registrar o pagamento: " . $stmt->error;
    }
    
    // Fecha o statement e a conexão
    $stmt->close();
    $conn->close();

} else {
    // Se a requisição não for POST, redireciona de volta para o formulário
    header("Location: propinas.php");
    exit;
}
?>